#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
网络测试工具箱 Linux版 - Flask Web应用
基于Windows版本network_toolkit-V8.py改造
"""

from flask import Flask, render_template, jsonify, request, send_file, stream_with_context
import os
import sys

# 添加项目根目录到路径
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))

app = Flask(__name__)
app.config['SECRET_KEY'] = 'network-toolkit-linux-v1.0'
app.config['JSON_AS_ASCII'] = False

# 初始化授权管理器
license_manager = None
try:
    from auth_client import LicenseManager
    license_manager = LicenseManager()
    print(f"授权系统初始化成功，HWID: {license_manager.hwid[:30]}...")
except Exception as e:
    print(f"警告: 授权系统初始化失败: {e}")
    import traceback
    traceback.print_exc()
    # 即使初始化失败，也创建一个简单的对象来存储硬件码
    try:
        from auth_client import get_hwid
        hwid = get_hwid()
        # 创建一个简单的对象来存储硬件码
        class SimpleLicenseManager:
            def __init__(self, hwid):
                self.hwid = hwid
                self.is_activated = False
                self.license_info = {}
            def get_status(self):
                return {
                    'is_activated': False,
                    'hwid': self.hwid,
                    'license_info': {}
                }
        license_manager = SimpleLicenseManager(hwid)
        print(f"使用简化授权管理器，HWID: {hwid[:30]}...")
    except Exception as e2:
        print(f"无法创建简化授权管理器: {e2}")
        license_manager = None

# 导入路由
from routes import main_bp, ping_bp, tracert_bp, portscan_bp, hostdiscovery_bp
from routes import subnet_bp, ipinfo_bp, dhcp_bp, services_bp
from routes import dashboard_bp, packet_bp, loop_bp, camera_bp, session_bp, ai_bp
from routes import network_tools_bp

# 注册蓝图
app.register_blueprint(main_bp)
app.register_blueprint(dashboard_bp)
app.register_blueprint(ping_bp)
app.register_blueprint(tracert_bp)
app.register_blueprint(portscan_bp)
app.register_blueprint(hostdiscovery_bp)
app.register_blueprint(subnet_bp)
app.register_blueprint(ipinfo_bp)
app.register_blueprint(dhcp_bp)
app.register_blueprint(services_bp)
app.register_blueprint(packet_bp)
app.register_blueprint(loop_bp)
app.register_blueprint(camera_bp)
app.register_blueprint(session_bp)
app.register_blueprint(ai_bp)
app.register_blueprint(network_tools_bp)

# 将授权管理器传递给app
app.license_manager = license_manager

@app.errorhandler(404)
def not_found(error):
    return jsonify({'error': '页面未找到'}), 404

@app.errorhandler(500)
def internal_error(error):
    return jsonify({'error': '服务器内部错误'}), 500

if __name__ == '__main__':
    print("=" * 60)
    print("网络测试工具箱 Linux版")
    print("=" * 60)
    print("访问地址: http://0.0.0.0:5000")
    print("按 Ctrl+C 停止服务")
    print("=" * 60)
    app.run(host='0.0.0.0', port=5000, debug=True, threaded=True)

